package com.qboxus.tictic.activitesfragments

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.util.Log
import android.view.View
import android.widget.AbsListView
import android.widget.Toast
import androidx.activity.result.contract.ActivityResultContracts
import androidx.activity.result.contract.ActivityResultContracts.RequestMultiplePermissions
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.chat.ChatActivity
import com.qboxus.tictic.activitesfragments.livestreaming.activities.LiveUsersActivity
import com.qboxus.tictic.activitesfragments.livestreaming.activities.MultiViewLiveActivity
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel
import com.qboxus.tictic.activitesfragments.profile.ProfileActivity
import com.qboxus.tictic.adapters.NotificationAdapter
import com.qboxus.tictic.apiclasses.ApiLinks
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.databinding.ActivityNotificationBinding
import com.qboxus.tictic.models.NotificationModel
import com.qboxus.tictic.models.StreamInviteModel
import com.qboxus.tictic.repositories.NotificationRepository
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.PermissionUtils
import com.qboxus.tictic.simpleclasses.Variables
import com.qboxus.tictic.viewModels.NotificationFactory
import com.qboxus.tictic.viewModels.NotificationViewModel
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError
import com.google.firebase.database.DatabaseReference
import com.google.firebase.database.FirebaseDatabase
import com.google.firebase.database.ValueEventListener
import com.volley.plus.VPackages.VolleyRequest
import org.json.JSONObject

class NotificationActivity : AppCompatLocaleActivity(), View.OnClickListener {
    lateinit var binding: ActivityNotificationBinding
    var takePermissionUtils: PermissionUtils? = null
    var adapter: NotificationAdapter? = null
    var datalist: ArrayList<NotificationModel?>? = null
    var mReceiver: NotificationBroadCast? = null
    var selectedNotificationModel: NotificationModel? = null
    var streamingType = ""
    var selectedPosition = 0
    var rootRef: DatabaseReference? = null
    var linearLayoutManager: LinearLayoutManager? = null
    var isActivityCallback = false

    lateinit var viewModel: NotificationViewModel
    private val userRepository = UserRepository()
    private val notificationRepository = NotificationRepository()


    private val mPermissionRejectResult = registerForActivityResult(
        RequestMultiplePermissions(),  { result ->
            var allPermissionClear = true
            val blockPermissionCheck: MutableList<String> = ArrayList()
            for (key in result.keys) {
                if (!result[key]!!) {
                    allPermissionClear = false
                    blockPermissionCheck.add(Functions.getPermissionStatus(this@NotificationActivity, key))
                }
            }
            if (blockPermissionCheck.contains("blocked")) {
                Functions.showPermissionSetting(
                    this@NotificationActivity,
                    getString(R.string.we_need_camera_and_recording_permission_for_live_streaming)
                )
            } else if (allPermissionClear) {
                inviteRequestStatusUpdate(
                    selectedNotificationModel!!.id,
                    selectedNotificationModel!!.live_streaming_id,
                    "2",
                    selectedPosition
                )
            }
        })

    private val mPermissionAcceptResult = registerForActivityResult(
        RequestMultiplePermissions(),  { result ->
            var allPermissionClear = true
            val blockPermissionCheck: MutableList<String> = ArrayList()
            for (key in result.keys) {
                if (!result[key]!!) {
                    allPermissionClear = false
                    blockPermissionCheck.add(Functions.getPermissionStatus(this@NotificationActivity, key))
                }
            }
            if (blockPermissionCheck.contains("blocked")) {
                Functions.showPermissionSetting(
                    this@NotificationActivity,
                    getString(R.string.we_need_camera_and_recording_permission_for_live_streaming)
                )
            } else if (allPermissionClear) {
                inviteRequestStatusUpdate(
                    selectedNotificationModel!!.id,
                    selectedNotificationModel!!.live_streaming_id,
                    "1",
                    selectedPosition
                )
            }
        })

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        Functions.setLocale(
            Functions.getSharedPreference(this@NotificationActivity)
                .getString(Variables.APP_LANGUAGE_CODE, Variables.DEFAULT_LANGUAGE_CODE),
            this,
            javaClass,
            false
        )
        binding = ActivityNotificationBinding.inflate(layoutInflater)
        setContentView(binding!!.root)

        val viewModelProviderFactory = NotificationFactory(this,userRepository,notificationRepository)
        viewModel = ViewModelProvider(this,viewModelProviderFactory)[NotificationViewModel::class.java]
        binding.viewModel=viewModel
        binding.lifecycleOwner = this

        binding!!.backBtn.setOnClickListener { v: View? -> onBackPressed() }
        rootRef = FirebaseDatabase.getInstance().reference
        datalist = ArrayList()
        linearLayoutManager = LinearLayoutManager(this@NotificationActivity)
        binding!!.recylerview.layoutManager = linearLayoutManager
        binding!!.recylerview.setHasFixedSize(true)
        adapter = NotificationAdapter(this@NotificationActivity, datalist) { view, postion, item ->
            selectedPosition = postion
            selectedNotificationModel = datalist!![selectedPosition]
            when (view.id) {
                R.id.watch_btn -> if (item.type == "live") {
                    openLivedUser()
                } else if (item.type.equals("video_comment", ignoreCase = true) || item.type.equals(
                        "video_like",
                        ignoreCase = true
                    )
                ) {
                    openWatchVideoWithComment(item)
                } else {
                    openWatchVideo(item)
                }

                R.id.btnAcceptRequest -> {
                    streamingType = item.type
                    if (item.type == "single" || item.type == "multiple") {
                        takePermissionUtils =
                            PermissionUtils(this@NotificationActivity, mPermissionAcceptResult)
                        if (takePermissionUtils!!.isCameraRecordingPermissionGranted) {
                            inviteRequestStatusUpdate(item.id, item.live_streaming_id, "1", postion)
                        } else {
                            takePermissionUtils!!.showCameraRecordingPermissionDailog(
                                getString(
                                    R.string.we_need_camera_and_recording_permission_for_live_streaming
                                )
                            )
                        }
                    }
                }

                R.id.btnDeleteRequest -> {
                    streamingType = item.type
                    if (item.type == "single" || item.type == "multiple") {
                        takePermissionUtils =
                            PermissionUtils(this@NotificationActivity, mPermissionRejectResult)
                        if (takePermissionUtils!!.isCameraRecordingPermissionGranted) {
                            inviteRequestStatusUpdate(item.id, item.live_streaming_id, "2", postion)
                        } else {
                            takePermissionUtils!!.showCameraRecordingPermissionDailog(
                                getString(R.string.we_need_camera_and_recording_permission_for_live_streaming)
                            )
                        }
                    }
                }

                R.id.follow_btn -> {
                    if (selectedNotificationModel?.senderModel?.button.equals("Friends")){
                        val intent = Intent(this@NotificationActivity, ChatActivity::class.java)
                        intent.putExtra("user_id", selectedNotificationModel?.senderModel?.id)
                        intent.putExtra("user_name", selectedNotificationModel?.senderModel?.username)
                        intent.putExtra("user_pic", selectedNotificationModel?.senderModel?.getProfilePic())
                        resultCallback.launch(intent)
                        overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
                    }else{
                        if (Functions.checkLoginUser(this@NotificationActivity)) {
                            selectedNotificationModel?.senderModel?.id?.let {
                                viewModel.followUser(
                                    it
                                )
                            }

                        }
                    }

                }

                else -> {
                    streamingType = item.type
                    if (item.type == "live") {
                        openLivedUser()
                    } else if (item.type == "single" || item.type == "multiple") {
                        openSingleStream()
                    } else {
                        openProfile(item)
                    }
                }
            }
        }
        binding!!.recylerview.adapter = adapter
        binding!!.recylerview.addOnScrollListener(object : RecyclerView.OnScrollListener() {
            var userScrolled = false
            var scrollOutitems = 0
            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)
                if (newState == AbsListView.OnScrollListener.SCROLL_STATE_TOUCH_SCROLL) {
                    userScrolled = true
                }
            }

            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                scrollOutitems = linearLayoutManager!!.findLastVisibleItemPosition()
                Functions.printLog("resp", "" + scrollOutitems)
                if (userScrolled && scrollOutitems == datalist!!.size - 1) {
                    userScrolled = false
                    if (viewModel.loadMoreLoaderVisibility.get()== false && !viewModel.ispostFinsh) {
                        viewModel.loadMoreLoaderVisibility.set(true)
                        viewModel.pageCount.set(viewModel.pageCount.get()+1)
                        viewModel.showAllNotifications()

                    }
                }
            }
        })
        binding!!.swiperefresh.setOnRefreshListener {
            if (datalist!!.size < 1) {
                binding!!.dataContainer.visibility = View.GONE
                binding!!.shimmerMainLayout.shimmerViewContainer.visibility = View.VISIBLE
                binding!!.shimmerMainLayout.shimmerViewContainer.startShimmer()
            }
            viewModel.pageCount.set(0)
            viewModel.showAllNotifications()

        }
        viewModel.readNotification()

        mReceiver = NotificationBroadCast()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            registerReceiver(mReceiver, IntentFilter("NotificationHit"), Context.RECEIVER_NOT_EXPORTED)
        }else{
            registerReceiver(mReceiver, IntentFilter("NotificationHit"))
        }

        setObserveAble()
    }

    fun setObserveAble() {

        viewModel.listLiveData.observe(this, {
            when (it) {
                is ApiResponce.Success -> {
                    it.data?.let {
                        if(viewModel.pageCount.get()==0) {
                            datalist?.clear()
                        }
                        datalist?.addAll(it)
                    }
                    changeUi()
                }

                is ApiResponce.Error -> {
                    changeUi()
                }
                is ApiResponce.Loading -> {
                }

            }
        })


        viewModel.followLiveData.observe(this, {
            when (it) {
                is ApiResponce.Success -> {
                    it.data?.let {
                        selectedNotificationModel?.senderModel?.button = it.button
                        datalist!![selectedPosition] = selectedNotificationModel
                        adapter!!.notifyDataSetChanged()
                    }
                }

                is ApiResponce.Error -> {
                }
                is ApiResponce.Loading -> {
                }

            }
        })


        viewModel.readNotificationLiveData.observe(this, {
            when (it) {
                is ApiResponce.Success -> {
                    isActivityCallback = true
                }

                is ApiResponce.Error -> {
                }
                is ApiResponce.Loading -> {
                }

            }
        })

    }

    fun changeUi(){
        if (datalist!!.isEmpty()) {
           viewModel.showNoData()
        } else {
            viewModel.hideNoData()
        }
        adapter?.notifyDataSetChanged()
        binding!!.shimmerMainLayout.shimmerViewContainer.stopShimmer()
        binding!!.shimmerMainLayout.shimmerViewContainer.visibility = View.GONE
        binding!!.dataContainer.visibility = View.VISIBLE
        binding!!.swiperefresh.isRefreshing = false
        viewModel.loadMoreLoaderVisibility.set(false)

    }


    var resultCallback = registerForActivityResult(
        ActivityResultContracts.StartActivityForResult()
    ) { result ->
        if (result.resultCode == RESULT_OK) {
            val data = result.data
            if (data!!.getBooleanExtra("isShow", false)) {
            }
        }
    }

    private fun openSingleStream() {
        goLive()
    }

    private fun inviteRequestStatusUpdate(
        id: String,
        streamingId: String,
        status: String,
        postion: Int
    ) {
        val parameters = JSONObject()
        try {
            parameters.put("id", id)
            parameters.put("status", status)
            parameters.put(
                "user_id",
                Functions.getSharedPreference(this@NotificationActivity).getString(Variables.U_ID, "")
            )
        } catch (e: Exception) {
            e.printStackTrace()
        }
        Functions.showLoader(this@NotificationActivity, false, false)
        VolleyRequest.JsonPostRequest(
            this,
            ApiLinks.acceptStreamingInvite,
            parameters,
            Functions.getHeaders(this@NotificationActivity)
        ) { resp ->
            Functions.checkStatus(this@NotificationActivity, resp)
            Functions.cancelLoader()
            try {
                val jsonObj = JSONObject(resp)
                if (jsonObj.optString("code").equals("200", ignoreCase = true)) {
                    val itemUpdate = datalist!![postion]
                    itemUpdate!!.status = status
                    datalist!![postion] = itemUpdate
                    adapter!!.notifyDataSetChanged()
                    if (status.equals("1", ignoreCase = true)) {
                        acceptStreamInvitation(streamingId)
                    } else {
                        deleteStreamInvitation(streamingId)
                    }
                }
            } catch (e: Exception) {
                Log.d(Constants.tag, "Exception : $e")
            }
        }
    }

    private fun deleteStreamInvitation(streamingId: String) {
        rootRef!!.child("LiveStreamingUsers")
            .child(streamingId)
            .child("StreamInvite")
            .child(Functions.getSharedPreference(this@NotificationActivity).getString(Variables.U_ID, "")!!)
            .removeValue()
    }

    private fun acceptStreamInvitation(streamingId: String) {
        val itemUpdate = StreamInviteModel()
        itemUpdate.setAccept(true)
        rootRef!!.child("LiveStreamingUsers")
            .child(streamingId)
            .child("StreamInvite")
            .child(Functions.getSharedPreference(this@NotificationActivity).getString(Variables.U_ID, "")!!)
            .setValue(itemUpdate).addOnCompleteListener { task ->
                if (task.isComplete) {
                    runOnUiThread { goLive() }
                }
            }
    }

    private fun goLive() {
        rootRef!!.child("LiveStreamingUsers")
            .child(selectedNotificationModel!!.live_streaming_id)
            .addListenerForSingleValueEvent(object : ValueEventListener {
                override fun onDataChange(snapshot: DataSnapshot) {
                    if (snapshot.exists()) {
                        val selectLiveModel = snapshot.getValue(
                            LiveUserModel::class.java
                        )
                        runOnUiThread { joinStream(selectLiveModel) }

                    } else {
                        runOnUiThread {
                            Toast.makeText(
                                this@NotificationActivity,
                                selectedNotificationModel?.senderModel?.username + " " + getString(R.string.is_offline_now),
                                Toast.LENGTH_SHORT
                            ).show()
                        }
                    }
                }

                override fun onCancelled(error: DatabaseError) {}
            })
    }


    private fun joinStream(selectLiveModel: LiveUserModel?) {
            val dataList = ArrayList<LiveUserModel?>()
            dataList.add(selectLiveModel)
            val intent = Intent()
            intent.putExtra("user_id", selectLiveModel?.getUserId())
            intent.putExtra("user_name", selectLiveModel?.getUserName())
            intent.putExtra("user_picture", selectLiveModel?.getUserPicture())
            intent.putExtra("user_role", io.agora.rtc2.Constants.CLIENT_ROLE_AUDIENCE)
            intent.putExtra("onlineType", "multicast")
            intent.putExtra("description", selectLiveModel?.getDescription())
            intent.putExtra("secureCode", "")
            intent.putExtra("dataList", dataList)
            intent.putExtra("position", 0)
            intent.setClass(this@NotificationActivity, MultiViewLiveActivity::class.java)
            startActivity(intent)

    }



    override fun onResume() {
        super.onResume()
        if (viewModel.pageCount.get() == 0 || Variables.reloadMyNotification) {
            Handler(Looper.getMainLooper()).postDelayed({
                Variables.reloadMyNotification = false
                if (datalist!!.size < 1) {
                    binding!!.dataContainer.visibility = View.GONE
                    binding!!.shimmerMainLayout.shimmerViewContainer.visibility = View.VISIBLE
                    binding!!.shimmerMainLayout.shimmerViewContainer.startShimmer()
                }
                viewModel.pageCount.set(0)
                viewModel.showAllNotifications()

            }, 200)
        }
    }


/*
    // get the all notification from the server against the profile id
    fun callApi() {
        if (isApiCall) {
            return
        }
        isApiCall = true
        if (datalist == null) datalist = ArrayList()
        val jsonObject = JSONObject()
        try {
            jsonObject.put("user_id", Functions.getSharedPreference(this@NotificationActivity).getString(Variables.U_ID, "0"))
            jsonObject.put("starting_point", "" + pageCount)
        } catch (e: Exception) {
            e.printStackTrace()
        }
        VolleyRequest.JsonPostRequest(
            this@NotificationActivity,
            ApiLinks.showAllNotifications,
            jsonObject,
            Functions.getHeaders(this)
        ) { resp ->
            isApiCall = false
            binding!!.shimmerMainLayout.shimmerViewContainer.stopShimmer()
            binding!!.shimmerMainLayout.shimmerViewContainer.visibility = View.GONE
            binding!!.dataContainer.visibility = View.VISIBLE
            binding!!.swiperefresh.isRefreshing = false
            parseData(resp)
        }
    }

    // parse the data of the notification and place then on data model list
    fun parseData(resp: String?) {
        try {
            val jsonObject = JSONObject(resp)
            val code = jsonObject.optString("code")
            if (code == "200") {
                val msg = jsonObject.getJSONArray("msg")
                val temp_list = ArrayList<NotificationModel?>()
                for (i in 0 until msg.length()) {
                    val data = msg.getJSONObject(i)
                    val notification = data.optJSONObject("Notification")
                    val video = data.optJSONObject("Video")
                    val senderUserDetailModel = getUserDataModel(data.optJSONObject("Sender"))
                    val receiverUserDetailModel = getUserDataModel(data.optJSONObject("Receiver"))
                    val item = NotificationModel()
                    item.senderModel=senderUserDetailModel
                    item.id = notification.optString("id")
                    item.status = notification.optString("status", "0")
                    item.live_streaming_id = notification.optString("live_streaming_id", "")
                    item.effected_fb_id = receiverUserDetailModel.id
                    item.type = notification.optString("type")
                    item.order_id = notification.optString("order_id")
                    if (item.type.equals(
                            "video_comment",
                            ignoreCase = true
                        ) || item.type.equals(
                            "video_like",
                            ignoreCase = true
                        ) || item.type.equals("video_updates", ignoreCase = true)
                    ) {
                        item.video_id = video.optString("id")
                        item.video = video.optString("video")
                        item.thum = video.optString("thum")
                        item.gif = video.optString("gif")
                    }
                    item.string = notification.optString("string")
                    item.created = notification.optString("created")
                    temp_list.add(item)
                }
                if (pageCount == 0) {
                    datalist!!.clear()
                    datalist!!.addAll(temp_list)
                } else {
                    datalist!!.addAll(temp_list)
                }
                adapter!!.notifyDataSetChanged()
            }
            if (datalist!!.isEmpty()) {
                binding!!.noDataLayout.visibility = View.VISIBLE
            } else {
                binding!!.noDataLayout.visibility = View.GONE
            }
        } catch (e: Exception) {
            e.printStackTrace()
        } finally {
            binding!!.loadMoreProgress.visibility = View.GONE
        }
    }

*/


    override fun onClick(v: View) {
        when (v.id) {

        }
    }

    // open the broad cast live user streaming on notification receive
    private fun openLivedUser() {
        val intent = Intent(this@NotificationActivity, LiveUsersActivity::class.java)
        startActivity(intent)
        overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
    }

    private fun openWatchVideo(item: NotificationModel) {
        val intent = Intent(this@NotificationActivity, WatchVideosActivity::class.java)
        intent.putExtra("video_id", item.video_id)
        intent.putExtra("position", 0)
        intent.putExtra("pageCount", 0)
        intent.putExtra(
            "userId",
            Functions.getSharedPreference(this@NotificationActivity).getString(Variables.U_ID, "")
        )
        intent.putExtra("whereFrom", "IdVideo")
        startActivity(intent)
    }

    private fun openWatchVideoWithComment(item: NotificationModel) {
        val intent = Intent(this@NotificationActivity, WatchVideosActivity::class.java)
        intent.putExtra("video_id", item.video_id)
        intent.putExtra("position", 0)
        intent.putExtra("pageCount", 0)
        intent.putExtra(
            "userId",
            Functions.getSharedPreference(this@NotificationActivity).getString(Variables.U_ID, "")
        )
        intent.putExtra("whereFrom", "IdVideo")
        if (item.type == "video_comment") {
            intent.putExtra("video_comment", true)
        }
        startActivity(intent)
    }

    // open the profile of the user which notification we have receive
    fun openProfile(item: NotificationModel) {
        if (Functions.checkProfileOpenValidation(item?.senderModel?.id)) {
            val intent = Intent(this@NotificationActivity, ProfileActivity::class.java)
            intent.putExtra("user_id", item?.senderModel?.id)
            intent.putExtra("user_name", item?.senderModel?.username)
            intent.putExtra("user_pic", item?.senderModel?.getProfilePic())
            startActivity(intent)
            overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        if (mReceiver != null) {
            unregisterReceiver(mReceiver)
            mReceiver = null
        }
    }

    override fun onBackPressed() {
        if (isActivityCallback) {
            val intent = Intent()
            intent.putExtra("isShow", true)
            setResult(RESULT_OK, intent)
        }
        finish()
    }

    inner class NotificationBroadCast : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent) {
            viewModel.pageCount.set(0)
            viewModel.showAllNotifications()
            viewModel.readNotification()
        }
    }

}
